<?php
session_start();

// Check if logged in
if (!isset($_SESSION['logged_in']) || $_SESSION['logged_in'] !== true) {
    header('Location: login.php');
    exit;
}

require_once 'includes/config.php';
require_once 'includes/functions.php';

// Get statistics
$stats = getStatistics();
$recentVisits = getRecentVisits(10);
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>URL Shortener - Dashboard</title>
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/flag-icon-css/6.6.6/css/flag-icons.min.css" rel="stylesheet">
    <link href="assets/style.css" rel="stylesheet">
</head>
<body class="dashboard">
    <!-- Header -->
    <header class="dashboard-header">
        <div class="header-content">
            <div class="logo">
                <i class="fas fa-link"></i>
                <span>URL Shortener SHADOW</span>
            </div>
            <div class="header-actions">
                <div class="notification-bell" id="notificationBell">
                    <i class="fas fa-bell"></i>
                    <span class="notification-count" id="notificationCount">0</span>
                </div>
                <a href="login.php?logout=1" class="logout-btn">
                    <i class="fas fa-sign-out-alt"></i>
                    Logout
                </a>
            </div>
        </div>
    </header>

    <!-- Notification Panel -->
    <div class="notification-panel" id="notificationPanel">
        <div class="notification-header">
            <h3>New Visits</h3>
            <button class="close-notifications" onclick="closeNotifications()">
                <i class="fas fa-times"></i>
            </button>
        </div>
        <div class="notification-list" id="notificationList">
            <!-- Notifications will be populated here -->
        </div>
    </div>

    <div class="dashboard-container">
        <!-- Sidebar -->
        <aside class="sidebar">
            <nav class="sidebar-nav">
                <a href="#" class="nav-item active" data-section="dashboard">
                    <i class="fas fa-tachometer-alt"></i>
                    Dashboard
                </a>
                <a href="#" class="nav-item" data-section="url-shortener">
                    <i class="fas fa-compress-alt"></i>
                    URL Shortener
                </a>
                <a href="#" class="nav-item" data-section="analytics">
                    <i class="fas fa-chart-bar"></i>
                    Analytics
                </a>
                <a href="#" class="nav-item" data-section="visits">
                    <i class="fas fa-eye"></i>
                    Recent Visits
                </a>
            </nav>
        </aside>

        <!-- Main Content -->
        <main class="main-content">
            <!-- Dashboard Overview Section -->
            <section id="dashboard-section" class="content-section active">
                <div class="section-header">
                    <h1>Dashboard Overview</h1>
                    <div class="last-updated">
                        Last updated: <span id="lastUpdated"><?php echo date('Y-m-d H:i:s'); ?></span>
                    </div>
                </div>

                <!-- Stats Cards -->
                <div class="stats-grid">
                    <div class="stat-card">
                        <div class="stat-icon">
                            <i class="fas fa-link"></i>
                        </div>
                        <div class="stat-content">
                            <div class="stat-number"><?php echo $stats['total_urls']; ?></div>
                            <div class="stat-label">Total URLs</div>
                        </div>
                    </div>

                    <div class="stat-card">
                        <div class="stat-icon">
                            <i class="fas fa-eye"></i>
                        </div>
                        <div class="stat-content">
                            <div class="stat-number"><?php echo $stats['total_visits']; ?></div>
                            <div class="stat-label">Total Visits</div>
                        </div>
                    </div>

                    <div class="stat-card">
                        <div class="stat-icon">
                            <i class="fas fa-users"></i>
                        </div>
                        <div class="stat-content">
                            <div class="stat-number"><?php echo $stats['human_visits']; ?></div>
                            <div class="stat-label">Human Visits</div>
                        </div>
                    </div>

                    <div class="stat-card">
                        <div class="stat-icon">
                            <i class="fas fa-robot"></i>
                        </div>
                        <div class="stat-content">
                            <div class="stat-number"><?php echo $stats['bot_visits']; ?></div>
                            <div class="stat-label">Bot Visits</div>
                        </div>
                    </div>
                </div>

                <!-- Recent Activity -->
                <div class="activity-section">
                    <h2>Recent Activity</h2>
                    <div class="activity-list" id="recentActivity">
                        <?php foreach ($recentVisits as $visit): ?>
                            <div class="activity-item">
                                <div class="activity-icon">
                                    <i class="fas fa-eye"></i>
                                </div>
                                <div class="activity-content">
                                    <div class="activity-text">
                                        New visit from 
                                        <span class="country-flag fi fi-<?php echo strtolower($visit['country_code'] ?? 'xx'); ?>"></span>
                                        <?php echo htmlspecialchars($visit['country'] ?? 'Unknown'); ?>
                                    </div>
                                    <div class="activity-time"><?php echo timeAgo($visit['timestamp']); ?></div>
                                </div>
                                <div class="activity-meta">
                                    <span class="visitor-type <?php echo $visit['is_human'] ? 'human' : 'bot'; ?>">
                                        <?php echo $visit['is_human'] ? 'Human' : 'Bot'; ?>
                                    </span>
                                </div>
                            </div>
                        <?php endforeach; ?>
                    </div>
                </div>
            </section>

            <!-- URL Shortener Section -->
            <section id="url-shortener-section" class="content-section">
                <div class="section-header">
                    <h1>URL Shortener</h1>
                    <p>Create short URLs with custom codes</p>
                </div>

                <div class="url-shortener-form">
                    <form id="shortenForm">
                        <div class="form-row">
                            <div class="form-group flex-grow">
                                <label for="originalUrl">Original URL</label>
                                <input type="url" id="originalUrl" placeholder="https://example.com" required>
                            </div>
                            <div class="form-group">
                                <label for="shortCode">Custom Code (Optional)</label>
                                <input type="text" id="shortCode" placeholder="custom-code">
                            </div>
                            <div class="form-group">
                                <button type="submit" class="btn btn-primary">
                                    <i class="fas fa-compress-alt"></i>
                                    Shorten URL
                                </button>
                            </div>
                        </div>
                    </form>
                </div>

                <div class="shortened-result" id="shortenedResult" style="display: none;">
                    <div class="result-content">
                        <h3>URL Shortened Successfully!</h3>
                        <div class="result-url">
                            <input type="text" id="resultUrl" readonly>
                            <button class="btn btn-secondary" onclick="copyToClipboard('resultUrl')">
                                <i class="fas fa-copy"></i>
                                Copy
                            </button>
                        </div>
                    </div>
                </div>

                <!-- URL List -->
                <div class="url-list-section">
                    <h2>Your URLs</h2>
                    <div class="url-list" id="urlList">
                        <!-- URLs will be loaded here -->
                    </div>
                </div>
            </section>

            <!-- Analytics Section -->
            <section id="analytics-section" class="content-section">
                <div class="section-header">
                    <h1>Analytics</h1>
                    <p>Detailed visitor analytics and statistics</p>
                </div>

                <!-- Analytics Charts -->
                <div class="analytics-grid">
                    <div class="analytics-card">
                        <h3>Visitor Types</h3>
                        <div class="chart-container">
                            <canvas id="visitorTypeChart"></canvas>
                        </div>
                    </div>

                    <div class="analytics-card">
                        <h3>Top Countries</h3>
                        <div class="country-list" id="topCountries">
                            <!-- Countries will be loaded here -->
                        </div>
                    </div>

                    <div class="analytics-card">
                        <h3>Device Types</h3>
                        <div class="chart-container">
                            <canvas id="deviceTypeChart"></canvas>
                        </div>
                    </div>

                    <div class="analytics-card">
                        <h3>Operating Systems</h3>
                        <div class="os-list" id="topOS">
                            <!-- OS data will be loaded here -->
                        </div>
                    </div>
                </div>
            </section>

            <!-- Recent Visits Section -->
            <section id="visits-section" class="content-section">
                <div class="section-header">
                    <h1>Recent Visits</h1>
                    <div class="section-actions">
                        <select id="visitFilter" class="filter-select">
                            <option value="all">All Visits</option>
                            <option value="human">Human Only</option>
                            <option value="bot">Bots Only</option>
                        </select>
                    </div>
                </div>

                <div class="visits-table">
                    <table class="data-table">
                        <thead>
                            <tr>
                                <th>Time</th>
                                <th>Country</th>
                                <th>IP Address</th>
                                <th>Device</th>
                                <th>OS</th>
                                <th>Network</th>
                                <th>ISP</th>
                                <th>Type</th>
                                <th>URL</th>
                            </tr>
                        </thead>
                        <tbody id="visitsTableBody">
                            <!-- Visits will be loaded here -->
                        </tbody>
                    </table>
                </div>
            </section>
        </main>
    </div>

    <script src="https://cdnjs.cloudflare.com/ajax/libs/Chart.js/3.9.1/chart.min.js"></script>
    <script src="assets/script.js"></script>
</body>
</html>

<?php
// Handle logout
if (isset($_GET['logout'])) {
    session_destroy();
    header('Location: login.php');
    exit;
}
?>
